@extends('layouts.admin')

@section('title', 'Coupon Management')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <div class="d-flex justify-content-between align-items-center">
            <h1>Coupon Management</h1>
            <a href="{{ route('admin.coupons.create') }}" class="btn btn-primary">
                <i class="fas fa-plus-circle"></i> Create Coupon
            </a>
        </div>
        <p>Manage your discount coupons</p>
    </div>

    <div class="dashboard-card">
        <div class="dashboard-card-header">
            <h3>Coupons</h3>
        </div>
        <div class="dashboard-card-body">
            <div class="table-responsive">
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Code</th>
                            <th>Type</th>
                            <th>Value</th>
                            <th>Used</th>
                            <th>Max Uses</th>
                            <th>Status</th>
                            <th>Valid From</th>
                            <th>Expires At</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($coupons as $coupon)
                        <tr>
                            <td>{{ $coupon->id }}</td>
                            <td><strong>{{ $coupon->code }}</strong></td>
                            <td>{{ ucfirst($coupon->type) }}</td>
                            <td>
                                @if($coupon->type === 'percentage')
                                    {{ $coupon->value }}%
                                @else
                                    ${{ number_format($coupon->value, 2) }}
                                @endif
                            </td>
                            <td>{{ $coupon->uses }}</td>
                            <td>{{ $coupon->max_uses ?? '∞' }}</td>
                            <td>
                                @if($coupon->isValid())
                                    <span class="badge badge-success">Valid</span>
                                @else
                                    <span class="badge badge-danger">Invalid</span>
                                @endif
                            </td>
                            <td>{{ $coupon->starts_at ? $coupon->starts_at->format('Y-m-d') : '—' }}</td>
                            <td>{{ $coupon->expires_at ? $coupon->expires_at->format('Y-m-d') : '—' }}</td>
                            <td class="user-actions">
                                <a href="{{ route('admin.coupons.edit', $coupon) }}" class="btn-icon btn-success" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <form action="{{ route('admin.coupons.destroy', $coupon) }}" method="POST" onsubmit="return confirm('Delete this coupon?');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn-icon btn-danger" title="Delete">
                                        <i class="fas fa-trash"></i>
                                    </button>
                                </form>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="10" class="text-center">No coupons found</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection